import java.util.ArrayList;

public class Store {
	private Employer owner;
	private ArrayList<Item> itemsInStock = new ArrayList();
	private String name;
	
	/** Constructor: creates a new store with name n and owner o **/
	public Store(String n, Employer o) {
		name  = n;
		owner = o;
	}
	
	/** = the owner **/
	public Employer getOwner() {
		return owner;
	}
	
	/** = the name of the store **/
	public String getName() {
		return name;
	}
	
	/** sets the owner of the store to o **/
	public void setOwner(Employer o) {
		owner = o;
	}
	
	/** sets the name of the store to n **/
	public void setName(String n) {
		name = n;
	}
	
	/** adds an item to the store and charges the owner for it **/
	public void stockItem(Item i) {
		Transfer.transfer(owner, i.getPrice());
		itemsInStock.add(i);
	}
	
	/** checks how many of a type of item are in stock **/
	public int inStock(String name) {
		int num = 0;
		
		for (int i = 0; i < itemsInStock.size(); ++i) {
			if (itemsInStock.get(i).getName().equals(name))
				++num;
		}
		
		return num;
	}
	
	/** changes the price of all items named name **/
	public void setPrices(String name, int price) {
		for (int i = 0; i < itemsInStock.size(); ++i) {
			if (itemsInStock.get(i).getName().equals(name))
				itemsInStock.get(i).setPrice(price);
		}
	}
	
	/** Person p purchases an item i from the store **/
	public void purchaseItem(Person p, Item i) {
		itemsInStock.remove(i);
		Transfer.transfer(p, owner, i.getPrice());
	}
	
	/** Purchases an item i from the store with credit card c **/
	public void purchaseItem(CreditCardAccount c, Item i) {
		itemsInStock.remove(i);
		Transfer.transfer(c, owner, i.getPrice());
	}
	
	/** Person p returns an item i to the store **/
	public void returnItem(Person p, Item i) {
		itemsInStock.add(i);
		Transfer.transfer(owner, p, i.getPrice());
	}
	
	/** = an item in stock with name n **/
	public Item getItem(String n) {
		for (int i = 0; i < itemsInStock.size(); ++i) {
			if (itemsInStock.get(i).getName().equals(name)) {
				return itemsInStock.get(i);
			}
		}
		System.out.println("This item is not in stock");
		return null;
	}
	
	
	
	
	

}